//---------------------------------------------------------------
// Fichero:  DosQuintos.asy
// Objetivo: Dibujar dos quintos en un rectángulo
// Fecha:    D.14.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo individual
path Rectangulo = box ((0,0),(1,2));

// Los rectángulos marcados
fill (box ((0,0),(2,2)), mediumgray);

// El rectángulo grande
for ( int i=0; i<=4; ++i )
    { draw(shift(i, 0) * Rectangulo); }
