//---------------------------------------------------------------
// Fichero:  sumamismo.asy
// Objetivo: Representar una suma de fracciones con el mismo denominador
// Fecha:    V.26.2.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El cuadradito básico
path Cuadrado = box((0,0), (1,1));

// La separación entre las representaciones de las fracciones
real Separacion = 0.5;

// Los rectángulos que marcan los numeradores
fill (box ((0,0),(5,1)), mediumgray);
fill (box ((2,1+Separacion),(5, 2+Separacion)), mediumgray);
fill (box ((0,2+2*Separacion),(2, 3+2*Separacion)), mediumgray);

// Las representaciones de las tres fracciones
for ( int j=0 ; j<3 ; ++j )
    {
    for ( int i=0 ; i<7 ; ++i )
        { draw(shift(i, j+j*Separacion) * Cuadrado); }
    }

// Las frechas que van desde los sumandos hasta el resultado
draw((0.5,2+1.8*Separacion) -- (0.5,1+0.3*Separacion), deepgreen, Arrow(5bp));
draw((1.5,2+1.8*Separacion) -- (1.5,1+0.3*Separacion), deepgreen, Arrow(5bp));
draw((2.5,1+0.8*Separacion) -- (2.5,1+0.3*Separacion), deepgreen, Arrow(5bp));
draw((3.5,1+0.8*Separacion) -- (3.5,1+0.3*Separacion), deepgreen, Arrow(5bp));
draw((4.5,1+0.8*Separacion) -- (4.5,1+0.3*Separacion), deepgreen, Arrow(5bp));

// Las fracciones
label("$\frac{2}{7}$", (0,2.5+2*Separacion), W);
label("$\frac{3}{7}$", (0,1.5+Separacion), W);
label("$\frac{5}{7}$", (7,0.5), E);
