//---------------------------------------------------------------
// Fichero:  paso1.asy
// Objetivo: Representar el paso 1 de un producto de fracciones
// Fecha:    M.2.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo básico vertical
path RectanguloVertical = box((0,0), (1,3));

// El rectángulo que marca el numerador
fill(box((0,0),(5,3)), mediumgray);

// Los rectángulos
for ( int i=0 ; i<7 ; ++i )
    { draw(shift(i,0) * RectanguloVertical); }

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// La flecha que marca la fracción
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// La fracción
label("$\frac{5}{7}$", (2.5,-4*Separacion), fontsize(16pt));
