//---------------------------------------------------------------
// Fichero:  paso2.asy
// Objetivo: Representar el paso 2 de un producto de fracciones
// Fecha:    M.2.3.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para cambiar el tamaño del texto
import fontsize;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// El rectángulo que marca el numerador vertical
fill(box((0,0),(5,3)), mediumgray);

// El rectángulo que marca el numerador horizontal
fill(box((0,1),(5,3)), palered);

// Los rectángulos verticales
draw(box((0,0),(5,3)));
draw(box((5,0),(7,3)));

// Las líneas horizontales
pen Punteado = linetype(new real[] {2,2});
draw((0,1) -- (5,1), Punteado);
draw((0,2) -- (5,2), Punteado);

// La separación entre las flechas y el objeto
real Separacion = 0.3;

// Las flechas que marcan las fracciones
draw((-Separacion,1) -- (-Separacion,3),
     blue, Arrows(HookHead,5bp), Bars(2mm));
draw((0,-Separacion) -- (5,-Separacion),
     blue, Arrows(HookHead,5bp), Bars(2mm));

// Las fracciones
label("$\frac{5}{7}$", (2.5,-4*Separacion), fontsize(16pt));
label("$\frac{2}{3}$", (-3*Separacion,2), fontsize(16pt));
