//---------------------------------------------------------------
// Fichero:  enunciado11.asy
// Objetivo: Representar el enunciado 11
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R=PuntoCir(39);
pair S=(0,-0.4);

// El vértice
pair V=(0,0);

// Los ángulos
markangle("$\alpha$", radius=5mm, R, V, (-1,0), 0.5bp+blue);
markangle("$129^\circ$", radius=8mm, S, V, R, 0.5bp+blue);
markrightangle((1,0), V, S, 3mm, gray);

// Dibujamos las rectas
draw((-0.7,0) -- (0.8,0));
draw(S -- V -- R);
