//---------------------------------------------------------------
// Fichero:  enunciado13.asy
// Objetivo: Representar el enunciado 13
// Fecha:    M.27.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Los extremos de las rectas
pair R1=PuntoCir(32), R2=-0.99*R1;
pair S1=0.5*PuntoCir(122), S2=-0.2*S1;
pair T1=(1,0), T2=(-1,0);
pair U1=(1,-0.3), U2=(-1,-0.3);

// Los vértices
pair V1=(0,0);
pair V2=intersectionpoint(U1 -- U2, R1 -- R2);

// Los ángulos
markangle("$\alpha$", radius=5mm, R2, V2, U1, 0.5bp+blue);
markangle("$68^\circ$", radius=5mm, S1, V1, T2, 0.5bp+blue);
markrightangle(R1, V1, S1, 4mm, gray);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
draw(T1 -- T2);
draw(U1 -- U2);
