//---------------------------------------------------------------
// Fichero:  dosrecto.asy
// Objetivo: Representar dos ángulos rectos y el llano que forman
// Fecha:    X.21.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle(), markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de dos rectas
pair A1=(0,0.4), B1=(0,-0.05);
pair A2=(1,0), B2=(-1,0);

// El vértice
pair V=(0,0);

// Marcamos los ángulos rectos
markrightangle(A1, V, A2, 2mm, 0.5bp+black);
markrightangle(A1, V, B2, 3mm, 0.5bp+black);

// Marcamos el ángulo llano
markangle(radius=5mm, A2, V, B2, 0.5bp+black);

// Las rectas
draw(A1 -- B1);
draw(A2 -- B2);

// Marcamos el vértice
dot(V, 4bp+black);
