//---------------------------------------------------------------
// Fichero:  recto.asy
// Objetivo: Representar cuatro ángulos rectos
// Fecha:    J.7.3.2024
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de dos rectas
pair A1=(0,1), B1=(0,-1);
pair A2=(1,0), B2=(-1,0);

// El vértice
pair V=(0,0);

// Marcamos los ángulos rectos
markrightangle(A1, V, A2, 2mm, 0.5bp+black);
markrightangle(A1, V, B2, 3mm, 0.5bp+black);
markrightangle(A2, V, B1, 3mm, 0.5bp+black);
markrightangle(B1, V, B2, 4mm, 0.5bp+black);

// Las rectas
draw(A1 -- B1);
draw(A2 -- B2);

// Marcamos el vértice
dot(V, 4bp+black);
