//---------------------------------------------------------------
// Fichero:  ejemplo2.asy
// Objetivo: Representar una recta bisectriz
// Fecha:    V.23.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (0.5*Cos(angulo),0.5*Sin(angulo)); }

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos
pair A=PuntoCir(40), Q=PuntoCir(0), B=PuntoCir(-40);

// Los ángulos
markangle("$\alpha:2$", radius=5mm, Q, V, A, 0.5bp+heavyred);
markangle("$\alpha:2$",radius=7mm, B, V, Q, 0.5bp+heavyred);
markangle(radius=20mm, B, V, A, 0.5bp+blue);
label("$\alpha$", (0.25,-0.1), E, blue);

// Dibujamos los lados
draw(V -- A);
draw(V -- B);
draw((-0.1,0) -- Q);

// El nombre de la recta
label("$s$", Q, E);

// Marcamos el vértice
dot(V, 4bp+black);
