//---------------------------------------------------------------
// Fichero:  ejemplo3.asy
// Objetivo: Representar una recta bisectriz y distancias
// Fecha:    V.23.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (0.5*Cos(angulo),0.5*Sin(angulo)); }

// Tamaño de la imagen
size(6cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// El ángulo de las rectas
real Ang=35;

// Los extremos de las rectas
pair A=PuntoCir(Ang), Z=PuntoCir(0), B=PuntoCir(-Ang);

// Definimos dos rectas
path a = V -- A;
path b = V -- B;

// Dibujamos los lados
draw(a); draw(b);
draw((-0.2,0) -- Z);

// Dibujamos las prolongaciones de los lados
pair A1=V-0.35*A;
pair B1=V-0.35*B;
path a1 = V -- A1;
path b1 = V -- B1;
pen Punteado = linetype(new real[] {2,2});
draw(a1, Punteado);
draw(b1, Punteado);

// Los nombres de las rectas
label("$a$", A, NE);
label("$b$", B, SE);
label("$t$", Z, E);

// Marcamos el vértice
dot(V, 4bp+black);

// Puntos de la bisectriz
pair P=(0.2,0), Q=(0.42,0), R=(-0.15,0);

// Los vectores perpendicular a las rectas a y b
pair Va=(-Sin(Ang), Cos(Ang));
pair Vb=(Sin(Ang), Cos(Ang));

// Los puntos de corte de a y b con las perpendiculares
pair Pa=extension(A,V,P,P+Va);
pair Pb=extension(B,V,P,P+Vb);
pair Qa=extension(A,V,Q,Q+Va);
pair Qb=extension(B,V,Q,Q+Vb);
pair Ra=extension(A,V,R,R+Va);
pair Rb=extension(B,V,R,R+Vb);

// Las distancias de los puntos de la bisectriz a los lados
draw(P -- Pa, blue);
draw(P -- Pb, blue);
draw(Q -- Qa, heavygreen);
draw(Q -- Qb, heavygreen);
draw(R -- Ra, magenta);
draw(R -- Rb, magenta);

// Marcamos los ángulos rectos
markrightangle(V, Pa, P, 2mm, gray);
markrightangle(V, Qa, Q, 2mm, gray);
markrightangle(V, Ra, R, 2mm, gray);
markrightangle(V, Pb, P, 2mm, gray);
markrightangle(V, Qb, Q, 2mm, gray);
markrightangle(V, Rb, R, 2mm, gray);

// Marcamos todos los puntos
dot("P", P, NE, 4bp+black);
dot("Q", Q, NE, 4bp+black);
dot("R", R, NW, 4bp+black);
dot(Pa, 4bp+black);
dot(Pb, 4bp+black);
dot(Qa, 4bp+black);
dot(Qb, 4bp+black);
dot(Ra, 4bp+black);
dot(Rb, 4bp+black);
