//---------------------------------------------------------------
// Fichero:  angulo90.asy
// Objetivo: Representar un ángulo de 90° como suma de 42° y 48°
// Fecha:    V.23.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (0.25*Cos(angulo),0.25*Sin(angulo)); }

// Los extremos de los lados
pair L1=PuntoCir(0), L2=PuntoCir(32), L3=PuntoCir(90);

// Dibujamos los lados
draw(L1 -- V -- L2);
draw(V -- L3);

// Las marcas de los ángulos
markangle("$32^\circ$", radius=10mm, L1, V, L2, 0.5bp+black);
markangle("$58^\circ$", radius=15mm, L2, V, L3, 0.5bp+black);
markangle("$90^\circ$", radius=25mm, L1, V, L3, 0.75bp+blue);

// Marcamos el vértice
dot(V, 4bp+black);
