//---------------------------------------------------------------
// Fichero:  opuestos.asy
// Objetivo: Representar ángulos opuestos por el vértice
// Fecha:    D.25.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// El vértice
pair V=(0,0);

// Los extremos de las rectas
pair R1=(-4,-2), R2=(4,2);
pair S1=(-4,2), S2=(4,-2);

// Los ángulos
markangle("$\alpha$", radius=5mm, S2, V, R2, 0.5bp+blue);
markangle("$\alpha$", radius=5mm, S1, V, R1, 0.5bp+blue);
markangle("$\beta$", radius=3mm, R2, V, S1, 0.5bp+blue);
markangle("$\beta$", radius=3mm, R1, V, S2, 0.5bp+blue);

// Dibujamos las rectas
draw(R1 -- R2);
draw(S1 -- S2);
label("$r$", R2, E);
label("$s$", S2, E);
