//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Puntos de la circunferencia
pair V1=PuntoCir(192), V2=PuntoCir(-80), A=PuntoCir(88), B=PuntoCir(30);

// El centro de la circunferencia
pair T=(0,0);

// Punto de corte de dos cuerdas
pair Q=intersectionpoint(V1 -- B, V2 -- A);

// Los ángulos
markangle("$\alpha$", radius=4mm, V2, Q, B, 0.5bp+blue);
markangle(Ang(B,V1,A,0), radius=8mm, B, V1, A, 0.5bp+blue);
markangle(Ang(V1,B,V2,0), radius=6mm, V1, B, V2, 0.5bp+blue);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(A -- V1 -- B);
draw(A -- V2 -- B);
