//---------------------------------------------------------------
// Fichero:  enunciado12.asy
// Objetivo: Representar el enunciado 2
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Función que devuelve un punto de la circunferencia según su ángulo
pair PuntoCir(real angulo)
    { return (Cos(angulo),Sin(angulo)); }

// Puntos de la circunferencia
pair V=PuntoCir(10), A=PuntoCir(-40), B=PuntoCir(140);

// El centro de la circunferencia
pair T=(0,0);
dot(T,4bp+black);

// Los ángulos
markangle(Ang(V,A,B,0), radius=6mm, V, A, B, 0.5bp+blue);
markangle("$\alpha$", radius=8mm, A, B, V, 0.5bp+blue);

// La circunferencia
draw(circle(T,1));

// Los lados de los ańgulos
draw(A -- V -- B);
draw(A -- T -- B);
