//---------------------------------------------------------------
// Fichero:  enunciado6.asy
// Objetivo: Enunciado 6
// Fecha:    M.6.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Los centros de las circunferencias
pair T1=(0,25), T2=(40,16);

// Los radios
int R1=25, R2=16;

// Puntos de tangencia
pair A=(T1.x,0), B=(T2.x,0);

// La circunferencias
draw(circle(T1,R1));
draw(circle(T2,R2));

// Punto de corte de las circunferencias
pair Q=intersectionpoint(circle(T1,R1),circle(T2,R2));

// El ángulo
markangle("$\alpha$", radius=10mm, A, Q, B, blue);
draw(A -- Q -- B);

// Los puntos
dot(Q, 3bp+black);
dot(T1, 3bp+black);
dot(T2, 3bp+black);
dot(A, 3bp+black);
dot(B, 3bp+black);

// La recta tangente
draw((-R1,0) -- (T2.x+R2,0));
