//---------------------------------------------------------------
// Fichero:  propiedadtangentes.asy
// Objetivo: Propiedad recta y circunferencia tangentes
// Fecha:    M.29.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Grosor de las líneas
defaultpen(1);

// Definición del centro, el punto de tangencia y otro punto
pair T=(0,0), G=(Cos(155), Sin(155)), H=(Cos(33),Sin(33));

// Dos puntos de la recta
pair A=G+(-G.y,G.x), B=G+(G.y,-G.x);

// Marcamos el ángulo recto
markrightangle(T, G, B, 2mm, gray);

// La circunferencia
draw(circle(T,1));

// El radio
draw(T -- H, blue);
label("$r$", (T+H)/2, NW, blue);

// La recta
draw(A -- B);

// La distancia entre la recta y el centro de la circunferencia
draw(T -- G, red);
label("$d$", (T+G)/2, S, red);

// Los puntos
dot(T, 3bp+black);
dot(G, 3bp+black);
