//---------------------------------------------------------------
// Fichero:  tangentesinteriores.asy
// Objetivo: Dos circunferencias tangentes interiores
// Fecha:    X.30.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los centros y los radios
pair T1=(0,0), T2=(0.3,0.3);
real R1=1, R2=R1-length(T2-T1);

// Las circunferencias
draw(circle(T1,R1));
draw(circle(T2,R2));

// Los puntos de corte
pair Cortes[] = intersectionpoints(circle(T1,R1),circle(T2,R2));
for ( pair K : Cortes )
    { dot(K, 3bp+blue); }
