//---------------------------------------------------------------
// Fichero:  propiedad.asy
// Objetivo: Propiedades del diámetro
// Fecha:    J.1.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// La circunferencia
draw(circle((0,0),1));

// Dos puntos de la circunferencia
pair A=(Cos(20),Sin(20)), B=(Cos(200),Sin(200));

// El diámetro
draw(A -- B, 2bp+blue);

// Los puntos
dot(A, 4bp+red);
dot(B, 4bp+red);
dot((0,0), 4bp+red);
label("T", (0,0), N);
label("A", A, NE);
label("B", B, SW);
