//---------------------------------------------------------------
// Fichero:  trapecio2.asy
// Objetivo: Representar otro trapecio circular
// Fecha:    J.8.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Extremos de las cuerdas
pair A1=(Cos(40),Sin(40)), B1=(Cos(120),Sin(120));
pair A2=scale(2)*A1, B2=scale(2)*B1;

// El trapecio
fill(A1 -- A2 -- arc((0,0),A2,B2,CW) -- B2 -- B1 -- arc((0,0),B1,A1) --
     cycle, gray);

// Dos circunferencias
path c1 = unitcircle, c2 = scale(2)*unitcircle;
draw(c1);
draw(c2);

// Dos trozos de radio
draw(A1 -- A2);
draw(B1 -- B2);

