//---------------------------------------------------------------
// Fichero:  central2.asy
// Objetivo: Representar otro ángulo central
// Fecha:    V.2.7.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.4cm);

// Grosor de las líneas
defaultpen(1);

// El centro de la circunferencia
pair T=(0,0);

// Puntos de la circunferencia
pair A=(Cos(40),Sin(40)), B=(Cos(-30),Sin(-30));

// La marca del ángulo
markangle(radius=4mm,A,T,B,4bp+blue+squarecap);

// La circunferencia
draw(circle(T,1));

// Los lados del ańgulo
draw(T -- 1.2*A);
draw(T -- 1.2*B);

// Los puntos
dot(T,3bp+red);
dot(A,3bp+red);
dot(B,3bp+red);
