//---------------------------------------------------------------
// Fichero:  rectangulo2.asy
// Objetivo: Ejercicio sobre rectángulo
// Fecha:    L.7.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// El giro
transform r=rotate(35);

// Definición de los vértices
pair A=(0,0), B=r*(23,0), C=r*(23,17), D=r*(0,17);

// Los ángulos rectos
markrightangle(D, A, B, 0.5bp+gray);
markrightangle(C, B, A, 0.5bp+gray);
markrightangle(D, C, B, 0.5bp+gray);
markrightangle(C, D, A, 0.5bp+gray);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, SE, blue);
label(Dist(B,C), (B+C)/2, NE, blue);
