//---------------------------------------------------------------
// Fichero:  rombo2.asy
// Objetivo: Ejercicio sobre rombo
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Semidiagonales del rombo
real d=48, g=55;

// El giro
transform r=rotate(45);

// Los vértices del rombo
pair A=r*(0,g), B=r*(d,0), C=r*(0,-g), D=r*(-d,0);

// El rombo
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker FormExt = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(A -- B, FormExt);
draw(B -- C, FormExt);
draw(C -- D, FormExt);
draw(D -- A, FormExt);

// Las flechas que marcan las dimensiones
pair V1=0.6*(C-A), V2=0.6*(B-D);
draw(B+V1 -- D+V1, blue, Arrows(HookHead,5bp));
draw(A+V2 -- C+V2, blue, Arrows(HookHead,5bp));

// Los textos
label(Dist(B,D), (B+D)/2+1.3*V1, blue);
label(Dist(A,C), (A+C)/2+1.3*V2, blue);
