//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 6
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// markangle() markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,0), C=(-4,-4), D=(0,2);

// Los ángulos
markangle(Ang(C,B,A,0), radius=12mm, A, B, C, 0.5bp+blue);
markrightangle(B, A, D, 5mm, 0.5bp+blue);
markangle("$\alpha$", radius=5mm, C, D, A, 0.5bp+blue);
markangle(Ang(D,C,B,0), radius=8mm, B, C, D, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
