//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(7,0), C=(6,6), D=(1,5);
pair E=(10,0), F=(11,7), G=B+0.7*(C-B);

// Los ángulos
markangle(Ang(D,A,B,0), radius=5mm, B, A, D, 0.5bp+blue);
markangle(Ang(B,C,D,0), radius=5mm, D, C, B, 0.5bp+blue);
markangle(Ang(C,D,A,1), radius=3mm, A, D, C, 0.5bp+blue);
markangle(Ang(F,G,B,1), radius=3mm, B, G, F, 0.5bp+blue);
markangle(Ang(E,F,G,0), radius=5mm, G, F, E, 0.5bp+blue);
markangle("$\alpha$", radius=3mm, F, E, B, 0.5bp+blue);

// Los cuadriláteros
draw(A -- B -- C -- D -- cycle);
draw(B -- E -- F -- G -- cycle);
