//---------------------------------------------------------------
// Fichero:  enunciado14.asy
// Objetivo: Representar el enunciado 14
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(1,0), C=(1+Cos(100),Sin(100)), D=0.74*(Cos(80),Sin(80));

// Los ángulos
markangle("$\alpha$", radius=6mm, B, A, D, 0.5bp+blue);
markangle("$\alpha$", radius=6mm, C, B, A, 0.5bp+blue);
markangle("$\alpha$", radius=6mm, D, C, B, 0.5bp+blue);
markangle("$120^\circ$", radius=6mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
