//---------------------------------------------------------------
// Fichero:  enunciado15.asy
// Objetivo: Representar el enunciado 15
// Fecha:    S.22.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P1-V)-degrees(P2-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,-3), B=(6,0.5), C=(0,3), D=(-4,0);

// Los ángulos
markangle("$\alpha$", radius=6mm, C, B, A, 0.5bp+blue);
markangle(Ang(B,A,D,1), radius=3mm, D, A, B, 0.5bp+blue);
markangle(Ang(D,C,B,1), radius=3mm, B, C, D, 0.5bp+blue);
markangle(Ang(C,D,A,1), radius=3mm, A, D, C, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);
