//---------------------------------------------------------------
// Fichero:  problema4.asy
// Objetivo: Representar el problema 4
// Fecha:    M.8.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve un vector en la dirección bisectriz
pair Bisectriz(pair P1, pair V, pair P2)
    { return unit(P1-V) + unit(P2-V); }

// Los vértices
pair A=(0,0), B=(Cos(70),Sin(70)), C=rotate(100,B)*A, D=(1.5,0);

// Las bisectrices
pair VC = Bisectriz(B,C,D);
pair C1 = C + VC;
pair VD = Bisectriz(A,D,C);
pair D1 = D + VD;

// El punto de corte de las bisectrices
pair F=extension(C, C1, D, D1);

// Las bisectrices
draw(C -- F -- D, gray);

// Los ángulos
markangle("$70^\circ$", radius=6mm, D, A, B, 0.5bp+blue);
markangle("$100^\circ$", radius=6mm, A, B, C, 0.5bp+blue);
markangle("$\gamma$", radius=5mm, B, C, F, 0.5bp+blue);
markangle("$\gamma$", radius=7mm, F, C, D, 0.5bp+blue);
markangle("$\beta$", radius=12mm, C, D, F, 0.5bp+blue);
markangle("$\beta$", radius=10mm, F, D, A, 0.5bp+blue);
markangle("$\alpha$", radius=4mm, D, F, C, 0.5bp+blue);

// El cuadrilatero
draw(A -- B -- C -- D -- cycle);

