//---------------------------------------------------------------
// Fichero:  problema2.asy
// Objetivo: Representar el problema 2
// Fecha:    X.9.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(Cos(144),Sin(144)), B=(0,0), C=(Cos(36),Sin(36)), D=A+(C-B);

// El punto auxiliar
pair Q=extension(B, B+(Cos(72),Sin(72)), A, C);

// Los ángulos
markangle("$\alpha$", radius=6mm, Q, D, C, 0.5bp+blue);
markangle("$\alpha$", radius=6mm, C, B, Q, 0.5bp+blue);
markangle("$2\alpha$", radius=6mm, B, A, D, 0.5bp+blue);
markangle("$2\alpha$", radius=8mm, Q, B, A, 0.5bp+blue);
markangle("$\beta$", radius=3mm, D, Q, B, 0.5bp+blue);
markangle("$\gamma$", radius=6mm, B, Q, D, 0.5bp+blue);

// Las líneas auxiliares
draw(D -- Q -- B, darkgray);

// El cuadrilatero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, N, 3bp+black);
dot("Q", Q, E, 3bp+black);
