//---------------------------------------------------------------
// Fichero:  problema4.asy
// Objetivo: Representar el problema 4
// Fecha:    X.9.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(17,-4), C=(25,6), D=(20,9);

// Los puntos medios
pair Q=(A+B)/2, R=(B+C)/2, S1=(C+D)/2, T=(D+A)/2;

// Un punto interior
pair Z=(15,1);

// Los cuadriláteros pequeños
fill(T -- Z -- S1 -- D -- cycle, gray);
fill(Q -- Z -- R -- B -- cycle, gray);

// El cuadrilatero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, W, 3bp+black);
dot("B", B, S, 3bp+black);
dot("C", C, E, 3bp+black);
dot("D", D, N, 3bp+black);
dot("Z", Z, 2.5*W, 3bp+black);
dot("Q", Q, S, 3bp+black);
dot("R", R, 0.5*S+E, 3bp+black);
dot("S", S1, NE, 3bp+black);
dot("T", T, NW, 3bp+black);
