//---------------------------------------------------------------
// Fichero:  complejo.asy
// Objetivo: Representar un cuadrilátero complejo
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(12,-1), C=(10,3), D=(2,2);

// El cuadrilátero
draw(A -- C -- B -- D -- cycle);

// Los vértices
dot("E", A, SW, 3bp+black);
dot("F", B, E, 3bp+black);
dot("G", C, NE, 3bp+black);
dot("H", D, NW, 3bp+black);

// El punto de corte
pair T=intersectionpoint(A -- C, B -- D);
dot(T, 3bp+black);
draw(circle(T,0.5bp),red);
