//---------------------------------------------------------------
// Fichero:  convexo.asy
// Objetivo: Representar un cuadrilátero convexo con sus ángulos
// Fecha:    V.21.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0cm,4cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(8,-1), C=(7,3), D=(1,2.5);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los vértices
dot("A", A, SW, 3bp+black);
dot("B", B, E, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);

// Los ángulos
pen FormAng=fontsize(8pt)+blue;
pen FormArc=0.5bp+blue;
markangle(Label("$\hat{\textup{A}}$",FormAng), radius=6mm, B, A, D, FormArc);
markangle(Label("$\hat{\textup{B}}$",FormAng), radius=5mm, C, B, A, FormArc);
markangle(Label("$\hat{\textup{C}}$",FormAng), radius=5mm, D, C, B, FormArc);
markangle(Label("$\hat{\textup{D}}$",FormAng), radius=3mm, A, D, C, FormArc);
