//---------------------------------------------------------------
// Fichero:  cuadrado.asy
// Objetivo: Representar un cuadrado
// Fecha:    D.23.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para StickIntervalMarker()
import markers;

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(2.5cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(5,5), D=(0,5);

// Los ángulos rectos
markrightangle(D, A, B, 0.5bp+blue);
markrightangle(C, B, A, 0.5bp+blue);
markrightangle(D, C, B, 0.5bp+blue);
markrightangle(C, D, A, 0.5bp+blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Las marcas
marker Formato = StickIntervalMarker(i=1, n=2, angle=45, size=3mm,
                                    space=1mm, p=blue);
draw(B -- C, Formato);
draw(A -- D, Formato);
draw(A -- B, Formato);
draw(C -- D, Formato);
