//---------------------------------------------------------------
// Fichero:  paso1.asy
// Objetivo: Representar el primer paso de la demostración
// Fecha:    M.25.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5.8cm);

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(6,0), C=(8,2), D=(2,2);

// La altura
pair Q=(3,2), R=(3,0);
draw(Q -- R, blue);

// El cuadrilátero
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot("A", A, SW, 3bp+black);
dot("B", B, SE, 3bp+black);
dot("C", C, NE, 3bp+black);
dot("D", D, NW, 3bp+black);
dot("Q", Q, SW, 3bp+black);
dot("R", R, NW, 3bp+black);

// Los ángulos rectos
markrightangle(B, R, Q, 2mm, 0.5bp+gray);
markrightangle(C, Q, R, 2mm, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((0,-Separacion) -- (6,-Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label("base", (A+B)/2, 3*S, blue);
label("altura", (Q+R)/2, E, blue);
