//---------------------------------------------------------------
// Fichero:  ejercicio1.asy
// Objetivo: Ilustrar la primera parte del ejercicio
// Fecha:    J.27.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Semidiagonales del rombo
real d=154/2, g=72/2;

// Los vértices del rombo
pair Q=(0,g), R=(d,0), S1=(0,-g), T=(-d,0);

// El centro
pair M=(0,0);

// El ángulo recto
markrightangle(R, M, Q, 2mm, 0.5bp+gray);

// Las diagonales
pen Punteado = linetype(new real[] {2,2});
draw(Q -- S1, Punteado+blue);
draw(T -- R, Punteado+blue);

// El rombo
draw(Q -- R -- S1 -- T -- cycle);

// Los puntos
dot("Q", Q, N, 3bp+black);
dot("R", R, E, 3bp+black);
dot("S", S1, S, 3bp+black);
dot("T", T, W, 3bp+black);
dot("M", M, SW, 3bp+black);

// Las flechas que marcan las dimensiones
real Separacion=25;
draw((-d,-g-Separacion) -- (d,-g-Separacion), blue, Arrows(HookHead,5bp));
draw(shift(25,0)*((d,-g) -- (d,g)), blue, Arrows(HookHead,5bp));

// Los textos
label("$a$", (Q+R)/2, NE, blue);
label(string(2*d), 1.2*(0,-g-Separacion), blue);
label(string(2*g), (1.5*d,0), blue);
