//---------------------------------------------------------------
// Fichero:  ejercicio2.asy
// Objetivo: Ilustrar la segunda parte del ejercicio
// Fecha:    J.27.5.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3cm);

// Grosor de las líneas
defaultpen(1);

// Los vértices del triángulo
pair Q=(0,36), R=(77,0), M=(0,0);

// El ángulo recto
markrightangle(R, M, Q, 4mm, 0.5bp+gray);

// El triángulo
draw(Q -- R -- M -- cycle);

// Los puntos
dot("Q", Q, N, 3bp+black);
dot("R", R, E, 3bp+black);
dot("M", M, SW, 3bp+black);

// Los textos
label("$a$", (Q+R)/2, NE, blue);
label("77", (M+R)/2, S, blue);
label("36", (Q+M)/2, W, blue);
