//---------------------------------------------------------------
// Fichero:  basesaltura.asy
// Objetivo: Representar las bases y la altura de un trapecio
// Fecha:    M.1.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto)
    { return Label(Texto,fontsize(8pt)+blue); }

// Definición de los vértices
pair A=(0,0), B=(8,0), C=(7,3), D=(3,3);

// La altura
pair P=(4,0), Q=(4,3);
draw(P -- Q, blue);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Los puntos
dot(A, 3bp+black);
dot(B, 3bp+black);
dot(C, 3bp+black);
dot(D, 3bp+black);
dot(P, 3bp+black);
dot(Q, 3bp+black);

// Los ángulos rectos
markrightangle(A, P, Q, 2mm, 0.5bp+gray);
markrightangle(D, Q, P, 2mm, 0.5bp+gray);

// Las flechas que marcan las dimensiones
real Separacion = 0.3;
draw((0,-Separacion) -- (8,-Separacion),
     blue, Arrows(HookHead,5bp));
draw((3,3+Separacion) -- (7,3+Separacion),
     blue, Arrows(HookHead,5bp));

// Los textos
label(Eti("base mayor ($B$)"), (A+B)/2, 3*S);
label(Eti("base menor ($b$)"), (C+D)/2, 3*N);
label(Eti("altura ($h$)"), (P+Q)/2, E);
