//---------------------------------------------------------------
// Fichero:  enunciado3.asy
// Objetivo: Mostrar el enunciado 3
// Fecha:    M.1.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4cm);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Grosor de las líneas
defaultpen(1);

// Los vértices
pair A=(0,0), B=(9,12), C=(9,20), D=(0,25);

// La altura
pair P=(0,16), Q=(9,16);
draw(P -- Q, heavygray);
markrightangle(D, P, Q, 0.5bp+gray);
markrightangle(C, Q, P, 0.5bp+gray);

// El trapecio
draw(A -- B -- C -- D -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, SE, blue);
label(Dist(C,D), (C+D)/2, NE, blue);
label(Dist(B,C), (B+C)/2, SE, blue);
label(Dist(D,A), (D+A)/2, W, blue);
label(Dist(P,Q), (P+Q)/2, S, blue);
