//---------------------------------------------------------------
// Fichero:  demostracion3.asy
// Objetivo: Tercer paso de la demostración
// Fecha:    V.4.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,2.5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve una etiqueta de tamaño determinado
Label Eti(string Texto)
    { return Label(Texto,fontsize(6pt)+blue); }

// Definición de los vértices
pair D=(3,0), E1=(1.5,2), R=(1.5,0);

// El ángulo recto
markrightangle(D, R, E1, 3mm, 0.5bp+gray);

// El triángulo
draw(E1 -- R -- D -- cycle);

// Los puntos
dot("D", D, SE, 3bp+black);
dot("E", E1, N, 3bp+black);
dot("R", R, SW, 3bp+black);

// Los textos
label(Eti("$(B-b):2$"), (R+D)/2, S, blue);
label("$h$", (E1+R)/2, W, blue);
label("$x$", (E1+D)/2, E, blue);
