//---------------------------------------------------------------
// Fichero:  estrellado.asy
// Objetivo: Representar un polígono estrellado
// Fecha:    J.8.4.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(3.5cm);

// Grosor de las líneas
defaultpen(1);

// Las líneas que unen vértices de un heptágono regular de dos en dos
guide Camino;
for (int i=1; i<=7; ++i)
    Camino = Camino -- point(polygon(7),2*i);

// Cerramos la línea y obtenemos el polígono
path Poligono = Camino -- cycle;

// Dibujamos el polígono
fill(Poligono,gray);

// Averiguamos los puntos de autocorte del polígono
pair[] Cortes = intersectionpoints(Poligono, Poligono);

// Con esta orden puedo ver el orden de los puntos obtenidos:
// for (int k=0; k<Cortes.length; ++k) dot(format("%i",k),Cortes[k],red);

// El orden correcto en que hay que dibujar los puntos para obtener el contorno
int Orden[] = {0,1,11,2,3,4,12,5,6,7,13,8,9,10};

// Montamos el contorno
path Contorno;
for ( int i=0 ; i<Orden.length ; ++i )
    { Contorno = Contorno -- Cortes[Orden[i]];}
Contorno = Contorno -- cycle;

// Dibujamos el contorno
draw(Contorno);
