//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Solución del enunciado 4
// Fecha:    D.13.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(4.5cm);

// Grosor de las líneas
defaultpen(1);

// El polígono
path Regular=polygon(6);
guide Camino;
for (int i=0; i<6; ++i)
    {
    if ( i<3 ) { Camino = Camino -- point(Regular,i)+(0.5,0.2); }
    else       { Camino = Camino -- point(Regular,i); }
    }
path Poligono=Camino -- cycle;

// Definición de los vértices
pair V[];
for (int i=0; i<length(Poligono); ++i)
    { V[i] = point(Poligono,i); }
V.cyclic=true;

// Las diagonales
for (int i=0; i<V.length; ++i)
    {
    draw(V[i] -- V[i+2], 1bp+heavygreen);
    draw(V[i] -- V[i+3], 1bp+heavygreen);
    }

// El polígono
guide Poligono;
for (int i=0; i<V.length; ++i)
    { Poligono = Poligono -- V[i]; }
  Poligono = Poligono -- cycle;
draw(Poligono);
