//---------------------------------------------------------------
// Fichero:  enunciado05.asy
// Objetivo: Representar el enunciado 5
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(1,2);

// Los ángulos
markangle("$\alpha$", radius=5mm, A, C, B, 0.5bp+blue);
markangle(Ang(B,A,C,0), radius=5mm, B, A, C, 0.5bp+blue);
markangle(Ang(C,B,A,0), radius=7mm, C, B, A, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- cycle);
