//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 7
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle(), markrightangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(5,0), C=(7,4), D=(0,3);

// Los ángulos
markangle("$\alpha$", radius=5mm, C, B, A, 0.5bp+blue);
markrightangle(D, A, B, 0.5bp+blue);
markangle(Ang(D,C,B,0), radius=5mm, D, C, B, 0.5bp+blue);
markangle(Ang(A,D,C,1), radius=5mm, A, D, C, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- D -- cycle);
