//---------------------------------------------------------------
// Fichero:  enunciado10.asy
// Objetivo: Representar el enunciado 10
// Fecha:    L.14.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Función que devuelve como cadena el valor redondeado en grados de un ángulo
string Ang(pair P1, pair V, pair P2, int e)
    { return string(round(degrees(P2-V)-degrees(P1-V))+360*e)+"$^\circ$"; }

// Grosor de las líneas
defaultpen(1);

// Definición de los vértices
pair A=(0,0), B=(10,0), C=(7,2), D=(5,5.3), E=(3,2);

// Los ángulos
markangle("$\alpha$", radius=2mm, D, E, A, 0.5bp+blue);
markangle("$\alpha$", radius=2mm, B, C, D, 0.5bp+blue);
markangle(Ang(B,A,E,0), radius=5mm, B, A, E, 0.5bp+blue);
markangle(Ang(C,B,A,0), radius=7mm, C, B, A, 0.5bp+blue);
markangle(Ang(E,D,C,0), radius=6mm, E, D, C, 0.5bp+blue);

// El polígono
draw(A -- B -- C -- D -- E -- cycle);
