//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Representar el enunciado 7
// Fecha:    D.20.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Para markangle()
import geometry;

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Número de lados
int n=5;

// El polígono
path Poligono=polygon(n);

// Definición de los vértices
pair V0=(0,0), V1=point(Poligono,1), V2=point(Poligono,3);

// El ángulo
draw(V2 -- V0 -- V1, 1bp+heavygray);
markangle("$\alpha$", radius=5mm, V1, V0, V2, 0.5bp+blue);

// El polígono
draw(Poligono);
