//---------------------------------------------------------------
// Fichero:  solucion3.asy
// Objetivo: Solución 3
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Función que dibuja un rombo de la solución
void DibujaRombo(pair A)
    {
    pair B=A+(2,-1), C=A+(4,0), D=A+(2,1);
    draw(A -- B -- C -- D -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    dot(D,3bp+deepgreen);
    }

// Constantes
int TotFil = 6, TotCol = 11;

// Los puntos básicos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i,j),3bp+gray); }
    }

// Los rombos
pair Base[] = {(0,2), (0,4), (2,1), (2,3), (4,2), (4,4), (6,1), (6,3) };
for ( int i=0 ; i<Base.length ; ++i )
    { DibujaRombo(Base[i]); }
