//---------------------------------------------------------------
// Fichero:  solucion4.asy
// Objetivo: Solución 4
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Función que dibuja un trapecio de la solución
void DibujaTrapecio(pair A)
    {
    pair B=A+(3,0), C=A+(2,1), D=A+(1,1);
    draw(A -- B -- C -- D -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    dot(D,3bp+deepgreen);
    }

// Función que dibuja otro trapecio de la solución
void DibujaTrapecioInverso(pair A)
    {
    pair B=A+(1,0), C=A+(2,1), D=A+(-1,1);
    draw(A -- B -- C -- D -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    dot(D,3bp+deepgreen);
    }

// Constantes
int TotFil = 6, TotCol = 11;

// Los puntos básicos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i,j),3bp+gray); }
    }

// Los trapecios
pair Base[] = {(0,0), (4,0), (0,2), (4,2), (0,4), (4,4), (2,1), (6,1),
               (2,3), (6,3) };
for ( int i=0 ; i<Base.length ; ++i )
    { DibujaTrapecio(Base[i]); }

pair Base[] = {(3,0), (7,0), (1,1), (5,1), (7,2), (1,3), (3,4), (7,4) };
for ( int i=0 ; i<Base.length ; ++i )
    { DibujaTrapecioInverso(Base[i]); }
