//---------------------------------------------------------------
// Fichero:  solucion5.asy
// Objetivo: Solución 5
// Fecha:    V.25.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(7.5cm);

// Constantes
int TotFil = 7, TotCol = 11;
real Altura=sqrt(3)/2;

// Función que dibuja un hexágono de la solución
void DibujaHexagono(pair A)
    {
    pair B=A+(1,0), C=A+(1.5,Altura), D=A+(1,2*Altura), E=D+(-1,0), F=C+(-2,0);
    draw(A -- B -- C -- D -- E -- F -- cycle,heavygreen);
    dot(A,3bp+deepgreen);
    dot(B,3bp+deepgreen);
    dot(C,3bp+deepgreen);
    dot(D,3bp+deepgreen);
    dot(E,3bp+deepgreen);
    dot(F,3bp+deepgreen);
    }

// Los puntos básicos
for ( int i=0 ; i<TotCol ; ++i )
    {
    for ( int j=0 ; j<TotFil ; ++j )
        { dot((i+j%2*0.5,j*Altura),3bp+heavygray); }
    }

// Líneas que terminan los triángulos
for ( int i=2 ; i<9 ; i+=2 )
    {
    for ( int j=0 ; j<TotFil ; j+=2 )
        { Draw((i,j*Altura) -- (i+1,j*Altura),heavygreen); }
    }


// Los hexágonos
for ( int i=1 ; i<TotCol ; i+=2 )
    {
    for ( int j=0 ; j<5 ; j+=2 )
        { DibujaHexagono((i,j*Altura)); }
    }
