//---------------------------------------------------------------
// Fichero:  enunciado07.asy
// Objetivo: Enunciado 7
// Fecha:    X.16.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(5cm);

// Grosor de las líneas
defaultpen(1);

// Función que devuelve como cadena la distancia redondeada entre dos puntos
string Dist(pair A, pair B)
    { return string(round(length(A-B))); }

// Los vértices
pair A=(10,0), B=(10,22), C=(15,22), D=(0,30), E1=(-15,22), F=(-10,22),
     G=(-10,0);

// El polígono
draw(A -- B -- C -- D -- E1 -- F -- G -- cycle);

// Las medidas
label(Dist(A,B), (A+B)/2, E, blue);
label(Dist(C,D), (C+D)/2, NE, blue);
label(Dist(A,G), (A+G)/2, S, blue);
label(Dist(B,C), (B+C)/2, S, blue);
