//---------------------------------------------------------------
// Fichero:  enunciado1.asy
// Objetivo: Enunciado 1
// Fecha:    V.18.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(10cm);

// Grosor de las líneas
defaultpen(1);

// Constantes
int Lado=3, TotFil=3, TotCol=9, Separacion=2;

// Los vértices exteriores
int Anchura=TotCol*Lado+(TotCol+1)*Separacion;
int Altura=TotFil*Lado+(TotFil+1)*Separacion;
pair A=(0,0), B=(Anchura,0), C=(Anchura,Altura), D=(0,Altura);

// El polígono exterior
filldraw(A-- B -- C -- D -- cycle, mediumgray, black);

// Los cuadrados
for ( int i=0 ; i<TotFil ; ++i )
    {
    for ( int j=0 ; j<TotCol ; ++j )
        {
        int OrigenX = Separacion + j*(Lado+Separacion);
        int OrigenY = Separacion + i*(Lado+Separacion);
        pair Origen = (OrigenX,OrigenY);
        filldraw(box(Origen, Origen+Lado*(1,1)), white, black);
        }
    }
