//---------------------------------------------------------------
// Fichero:  enunciado3a.asy
// Objetivo: Enunciado 3a
// Fecha:    V.18.6.2021
// Autor:    Pedro Reina
// Licencia: CC0 1.0 Universal
//           http://creativecommons.org/publicdomain/zero/1.0/
//---------------------------------------------------------------

// Obtendremos un archivo SVG
settings.outformat="svg";

// Tamaño de la imagen
size(0,3.4cm);

// Grosor de las líneas
defaultpen(1);

// Función que escribe la distancia entre dos puntos
void Dist(pair A, pair B, pair Pos)
    { label(string(round(length(A-B))), (A+B)/2, Pos, blue); }

// Función que marca un segmento entre dos puntos
void Segmento(pair A, pair B)
    {
    dot(A, 2bp+red);
    dot(B, 2bp+red);
    draw(A -- B, 0.75bp+red);
    }

// Los vértices exteriores
pair A1=(0,0), B1=(80,0), C1=(80,42), D1=(0,42);

// El polígono exterior
path Ext= A1-- B1 -- C1 -- D1 -- cycle;

// Los vértices interiores
pair A2=(6,5), B2=(6,37), C2=(69,21);

// El polígono interior
path Int= A2 -- B2 -- C2 -- cycle;

// El conjunto de polígonos
path[] Conjunto={Ext,Int};

// El dibujo
filldraw(Conjunto,mediumgray+evenodd,black);

// Segmentos auxiliares
Segmento((6,0), A2);
Segmento((0,5), A2);
Segmento((6,42), B2);
Segmento((0,37), B2);
Segmento((B1+C1)/2, C2);

// Las medidas
Dist(A1,B1,S);
Dist(B1,C1,E);
Dist((6,0),A2,E);
Dist((0,5),A2,N);
Dist((5,42),B2,E);
Dist((0,37),B2,S);
Dist((B1+C1)/2,C2,N);
